local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CVector'

shared.ffi.cdef[[
enum {
    SOUND_OFF = 0,
};

#pragma pack(push, 1)
struct SCAudio {
    BOOL m_bSoundLoaded;
};
typedef struct SCAudio SCAudio;
#pragma pack(pop)
]]

shared.validate_size('struct SCAudio', 0x4)

local SCAudio_mt = {
    Play = ffi.cast('void(__thiscall*)(SCAudio*, int, SCVector)', shared.GetAddress(0x9D730)),
    StartRadio = ffi.cast('void(__thiscall*)(SCAudio*, unsigned char)', shared.GetAddress(0x9D860)),
    GetRadioVolume = ffi.cast('float(__thiscall*)(SCAudio*)', shared.GetAddress(0x9D8A0)),
}
SCAudio_mt.__index = SCAudio_mt
ffi.metatype('struct SCAudio', SCAudio_mt)