local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CVector'

shared.ffi.cdef[[
enum {
    AUDIOSTREAM_MAX_STRING = 256,
};

#pragma pack(push, 1)
struct SCAudioStream {
    bool m_bInitialized;
};
typedef struct SCAudioStream SCAudioStream;
#pragma pack(pop)
]]

shared.validate_size('struct SCAudioStream', 0x1)

local function RefStream() return ffi.cast('int*', shared.GetAddress(0x11A60C))[0] end
local function RefIsPlaying() return ffi.cast('bool*', shared.GetAddress(0x11A610))[0] end
local function RefPosition() return ffi.cast('SCVector*', shared.GetAddress(0x11A614))[0] end
local function RefIs3d() return ffi.cast('bool*', shared.GetAddress(0x11A620))[0] end
local function ArrayIcyUrl() return ffi.cast('char* ', shared.GetAddress(0x11A508)) end
local function ArrayInfo() return ffi.cast('char* ', shared.GetAddress(0x11A400)) end
local function ArrayUrl() return ffi.cast('char* ', shared.GetAddress(0x11A2F8)) end
local function RefNeedsToDestroy() return ffi.cast('bool*', shared.GetAddress(0xF03AA))[0] end
local function RefRadius() return ffi.cast('float*', shared.GetAddress(0xF03AC))[0] end
local function ArrayIcyName() return ffi.cast('char* ', shared.GetAddress(0x11A1F0)) end
local ConstructInfo = ffi.cast('void(__cdecl*)()', shared.GetAddress(0x62A00))
local SyncProc = ffi.cast('void(__stdcall*)(int, int, int, void*)', shared.GetAddress(0x62B30))
local Process = ffi.cast('void(__cdecl*)(void*)', shared.GetAddress(0x62B40))

local SCAudioStream_mt = {
    Reset = ffi.cast('BOOL(__thiscall*)(SCAudioStream*)', shared.GetAddress(0x628C0)),
    Stop = ffi.cast('BOOL(__thiscall*)(SCAudioStream*, bool)', shared.GetAddress(0x629A0)),
    Play = ffi.cast('BOOL(__thiscall*)(SCAudioStream*, const char*, SCVector, float, bool)', shared.GetAddress(0x62DA0)),
    ControlGameRadio = ffi.cast('void(__thiscall*)(SCAudioStream*)', shared.GetAddress(0x62EC0)),
    DrawInfo = ffi.cast('void(__thiscall*)(SCAudioStream*)', shared.GetAddress(0x62EF0)),
}
SCAudioStream_mt.__index = SCAudioStream_mt
ffi.metatype('struct SCAudioStream', SCAudioStream_mt)

local function RefAudioStream() return ffi.cast('SCAudioStream**', shared.GetAddress(0x21A0F0))[0] end

return {
    RefStream = RefStream,
    RefIsPlaying = RefIsPlaying,
    RefPosition = RefPosition,
    RefIs3d = RefIs3d,
    ArrayIcyUrl = ArrayIcyUrl,
    ArrayInfo = ArrayInfo,
    ArrayUrl = ArrayUrl,
    RefNeedsToDestroy = RefNeedsToDestroy,
    RefRadius = RefRadius,
    ArrayIcyName = ArrayIcyName,
    ConstructInfo = ConstructInfo,
    SyncProc = SyncProc,
    Process = Process,
    RefAudioStream = RefAudioStream,
}