local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'v037r1.CEntity'
shared.require 'CMatrix'
shared.require 'CVector'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCCamera {
    SCEntity* m_pAttachedTo;
    SCMatrix* m_pMatrix;
};
typedef struct SCCamera SCCamera;
#pragma pack(pop)
]]

shared.validate_size('struct SCCamera', 0x8)

local CCamera_constructor = ffi.cast('void(__thiscall*)(SCCamera*)', 0x9B5A0)
local function CCamera_new(...)
    local obj = ffi.new('struct SCCamera[1]')
    CCamera_constructor(obj, ...)
    return obj
end

local SCCamera_mt = {
    Fade = ffi.cast('void(__thiscall*)(SCCamera*, bool)', shared.GetAddress(0x98DE0)),
    GetMatrix = ffi.cast('void(__thiscall*)(SCCamera*, SCMatrix*)', shared.GetAddress(0x98E00)),
    SetMatrix = ffi.cast('void(__thiscall*)(SCCamera*, SCMatrix)', shared.GetAddress(0x98E80)),
    TakeControl = ffi.cast('void(__thiscall*)(SCCamera*, CEntity*, short, short)', shared.GetAddress(0x98F10)),
    SetMoveVector = ffi.cast('void(__thiscall*)(SCCamera*, SCVector*, SCVector*, unsigned int, bool)', shared.GetAddress(0x98F30)),
    SetTrackVector = ffi.cast('void(__thiscall*)(SCCamera*, SCVector*, SCVector*, unsigned int, bool)', shared.GetAddress(0x98FA0)),
    Attach = ffi.cast('void(__thiscall*)(SCCamera*, SCEntity*)', shared.GetAddress(0x99000)),
    SetToOwner = ffi.cast('void(__thiscall*)(SCCamera*)', shared.GetAddress(0x99050)),
    GetDistanceToPoint = ffi.cast('float(__thiscall*)(SCCamera*, SCVector*)', shared.GetAddress(0x990A0)),
    Restore = ffi.cast('void(__thiscall*)(SCCamera*)', shared.GetAddress(0x991D0)),
    Set = ffi.cast('void(__thiscall*)(SCCamera*, SCVector, SCVector)', shared.GetAddress(0x99120)),
    PointAt = ffi.cast('void(__thiscall*)(SCCamera*, SCVector, int)', shared.GetAddress(0x99180)),
    Detach = ffi.cast('void(__thiscall*)(SCCamera*)', shared.GetAddress(0x990E0)),
}
SCCamera_mt.__index = SCCamera_mt
ffi.metatype('struct SCCamera', SCCamera_mt)

return {
    new = CCamera_new,
}