local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SPlayer {
    BOOL m_bExists;
    char m_szText[256];
    int m_creationTick;
    int m_lifeSpan;
    D3DCOLOR m_color;
    float m_fDrawDistance;
    int m_nMaxLineLength;
};
typedef struct SPlayer SPlayer;
#pragma pack(pop)

#pragma pack(push, 1)
struct SCChatBubble {
    SPlayer m_player[1004];
};
typedef struct SCChatBubble SCChatBubble;
#pragma pack(pop)
]]

shared.validate_size('struct SPlayer', 0x118)
shared.validate_size('struct SCChatBubble', 0x44a20)

local CChatBubble_constructor = ffi.cast('void(__thiscall*)(SCChatBubble*)', 0x63220)
local function CChatBubble_new(...)
    local obj = ffi.new('struct SCChatBubble[1]')
    CChatBubble_constructor(obj, ...)
    return obj
end

local SCChatBubble_mt = {
    Add = ffi.cast('void(__thiscall*)(SCChatBubble*, ID, const char*, D3DCOLOR, float, int)', shared.GetAddress(0x63250)),
    Draw = ffi.cast('void(__thiscall*)(SCChatBubble*)', shared.GetAddress(0x63310)),
}
SCChatBubble_mt.__index = SCChatBubble_mt
ffi.metatype('struct SCChatBubble', SCChatBubble_mt)

local function RefChatBubble() return ffi.cast('SCChatBubble**', shared.GetAddress(0x21A0DC))[0] end

return {
    new = CChatBubble_new,
    RefChatBubble = RefChatBubble,
}