local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'v037r1.CEntity'
shared.require 'v037r1.CVehicle'
shared.require 'v037r1.CObject'
shared.require 'CMatrix'
shared.require 'CVector'

shared.ffi.cdef[[
enum {
    MAX_OBJECTS = 1000,
};

#pragma pack(push, 1)
struct SCObjectPool {
    int m_nLargestId;
    BOOL m_bNotEmpty[1000];
    SCObject* m_pObject[1000];
};
typedef struct SCObjectPool SCObjectPool;
#pragma pack(pop)
]]

shared.validate_size('struct SCObjectPool', 0x1f44)

local CObjectPool_constructor = ffi.cast('void(__thiscall*)(SCObjectPool*)', 0xF3A0)
local CObjectPool_destructor = ffi.cast('void(__thiscall*)(SCObjectPool*)', 0xFCB0)
local function CObjectPool_new(...)
    local obj = ffi.gc(ffi.new('struct SCObjectPool[1]'), CObjectPool_destructor)
    CObjectPool_constructor(obj, ...)
    return obj
end

local function RefLastProcess() return ffi.cast('TICK*', shared.GetAddress(0x1049B0))[0] end

local SCObjectPool_mt = {
    UpdateLargestId = ffi.cast('void(__thiscall*)(SCObjectPool*)', shared.GetAddress(0xF340)),
    GetCount = ffi.cast('int(__thiscall*)(SCObjectPool*)', shared.GetAddress(0xF3D0)),
    Delete = ffi.cast('BOOL(__thiscall*)(SCObjectPool*, ID)', shared.GetAddress(0xF3F0)),
    Create = ffi.cast('BOOL(__thiscall*)(SCObjectPool*, ID, int, SCVector, SCVector, float)', shared.GetAddress(0xF470)),
    Find = ffi.cast('SCObject * (__thiscall*)(SCObjectPool*, CObject*)', shared.GetAddress(0xF520)),
    GetId = ffi.cast('int(__thiscall*)(SCObjectPool*, CObject*)', shared.GetAddress(0xF560)),
    Process = ffi.cast('void(__thiscall*)(SCObjectPool*)', shared.GetAddress(0xF5A0)),
    ConstructMaterials = ffi.cast('void(__thiscall*)(SCObjectPool*)', shared.GetAddress(0xF660)),
    ShutdownMaterials = ffi.cast('void(__thiscall*)(SCObjectPool*)', shared.GetAddress(0xF6A0)),
    Draw = ffi.cast('void(__thiscall*)(SCObjectPool*)', shared.GetAddress(0xF6E0)),
    DrawLast = ffi.cast('void(__thiscall*)(SCObjectPool*)', shared.GetAddress(0xF720)),
    -- Get = ...
}
SCObjectPool_mt.__index = SCObjectPool_mt
ffi.metatype('struct SCObjectPool', SCObjectPool_mt)

return {
    new = CObjectPool_new,
    RefLastProcess = RefLastProcess,
}