local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'v037r1.CEntity'
shared.require 'v037r1.CVehicle'
shared.require 'v037r1.CPed'
shared.require 'CMatrix'
shared.require 'CVector'
shared.require 'v037r1.CRemotePlayer'
shared.require 'v037r1.SpecialAction'
shared.require 'v037r1.ControllerState'
shared.require 'v037r1.Animation'
shared.require 'v037r1.AimStuff'
shared.require 'v037r1.Synchronization'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCPlayerInfo {
    SCRemotePlayer* m_pPlayer;
    BOOL m_bIsNPC;
    unsigned int __align;
    string m_szNick;
    int m_nScore;
    unsigned int m_nPing;
};
typedef struct SCPlayerInfo SCPlayerInfo;
#pragma pack(pop)

struct SAim {
    SCVector front;
    SCVector source;
    SCVector sourceBeforeLookBehind;
    SCVector up;
};
typedef struct SAim SAim;

#pragma pack(push, 1)
struct SOnfootData {
    SControllerState m_controllerState;
    SCVector m_position;
    float m_fQuaternion[4];
    unsigned char m_nHealth;
    unsigned char m_nArmor;
    unsigned char m_nCurrentWeapon;
    unsigned char m_nSpecialAction;
    SCVector m_speed;
    SCVector m_surfingOffset;
    ID m_nSurfingVehicleId;
    SAnimation m_animation;
};
typedef struct SOnfootData SOnfootData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SIncarData {
    ID m_nVehicle;
    SControllerState m_controllerState;
    float m_fQuaternion[4];
    SCVector m_position;
    SCVector m_speed;
    float m_fHealth;
    unsigned char m_nDriverHealth;
    unsigned char m_nDriverArmor;
    unsigned char m_nCurrentWeapon;
    bool m_bSirenEnabled;
    bool m_bLandingGear;
    ID m_nTrailerId;
    union {
        short unsigned int m_aHydraThrustAngle[2]; float m_fTrainSpeed;
    };
};
typedef struct SIncarData SIncarData;
#pragma pack(pop)

enum SWeaponState {
    WS_NO_BULLETS = 0,
    WS_LAST_BULLET = 1,
    WS_MORE_BULLETS = 2,
    WS_RELOADING = 3,
};
typedef enum SWeaponState SWeaponState;

#pragma pack(push, 1)
struct SAimData {
    unsigned char m_nCameraMode;
    SCVector m_aimf1;
    SCVector m_aimPos;
    float m_fAimZ;
    unsigned char m_nCameraExtZoom;
    unsigned char m_nWeaponState;
    char m_nAspectRatio;
};
typedef struct SAimData SAimData;
#pragma pack(pop)

#pragma pack(push, 1)
struct STrailerData {
    ID m_nId;
    SCVector m_position;
    float m_fQuaternion[4];
    SCVector m_speed;
    SCVector m_turnSpeed;
};
typedef struct STrailerData STrailerData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SPassengerData {
    ID m_nVehicleId;
    unsigned char m_nSeatId;
    unsigned char m_nCurrentWeapon;
    unsigned char m_nHealth;
    unsigned char m_nArmor;
    SControllerState m_controllerState;
    SCVector m_position;
};
typedef struct SPassengerData SPassengerData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SUnoccupiedData {
    ID m_nVehicleId;
    unsigned char m_nSeatId;
    SCVector m_roll;
    SCVector m_direction;
    SCVector m_position;
    SCVector m_speed;
    SCVector m_turnSpeed;
    float m_fHealth;
};
typedef struct SUnoccupiedData SUnoccupiedData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SBulletData {
    unsigned char m_nTargetType;
    ID m_nTargetId;
    SCVector m_origin;
    SCVector m_target;
    SCVector m_center;
    unsigned char m_nWeapon;
};
typedef struct SBulletData SBulletData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SSpectatorData {
    SControllerState m_controllerState;
    SCVector m_position;
};
typedef struct SSpectatorData SSpectatorData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SStatsData {
    int m_nMoney;
    int m_nDrunkLevel;
};
typedef struct SStatsData SStatsData;
#pragma pack(pop)
]]

shared.validate_size('struct SCPlayerInfo', 0x2c)
shared.validate_size('struct SAim', 0x30)
shared.validate_size('struct SOnfootData', 0x44)
shared.validate_size('struct SIncarData', 0x3f)
shared.validate_size('struct SAimData', 0x1f)
shared.validate_size('struct STrailerData', 0x36)
shared.validate_size('struct SPassengerData', 0x18)
shared.validate_size('struct SUnoccupiedData', 0x43)
shared.validate_size('struct SBulletData', 0x28)
shared.validate_size('struct SSpectatorData', 0x12)
shared.validate_size('struct SStatsData', 0x8)

local CPlayerInfo_constructor = ffi.cast('void(__thiscall*)(SCPlayerInfo*, const char*, BOOL)', 0x10CB0)
local CPlayerInfo_destructor = ffi.cast('void(__thiscall*)(SCPlayerInfo*)', 0x10A50)
local function CPlayerInfo_new(...)
    local obj = ffi.gc(ffi.new('struct SCPlayerInfo[1]'), CPlayerInfo_destructor)
    CPlayerInfo_constructor(obj, ...)
    return obj
end

local AimStuff = {}

-- RefLocalPlayerCameraExtZoom = ...
-- RefLocalPlayerAspectRatio = ...
-- RefInternalCameraExtZoom = ...
-- RefInternalAspectRatio = ...
-- ArrayCameraExtZoom = ...
-- ArrayAspectRatio = ...
-- ArrayCameraMode = ...
-- RefInternalCameraMode = ...
-- RefLocalPlayerAim = ...
-- ArrayPlayerAim = ...
-- RefInternalAim = ...
-- UpdateCameraExtZoomAndAspectRatio = ...
-- ApplyCameraExtZoomAndAspectRatio = ...
-- SetCameraExtZoomAndAspectRatio = ...
-- GetAspectRatio = ...
-- GetCameraExtZoom = ...
-- ApplyCameraExtZoomAndAspectRatio = ...
-- SetCameraMode = ...
-- GetCameraMode = ...
-- GetCameraMode = ...
-- Initialize = ...
-- UpdateAim = ...
-- ApplyAim = ...
-- GetAim = ...
-- SetAim = ...
-- ApplyAim = ...
-- GetAim = ...
local Synchronization = {}

-- CompressAspectRatio = ...
-- DecompressAspectRatio = ...
-- CompressCameraExtZoom = ...
-- DecompressCameraExtZoom = ...

return {
    new = CPlayerInfo_new,
    AimStuff = AimStuff,
    Synchronization = Synchronization,
}