local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'v037r1.CEntity'
shared.require 'v037r1.CVehicle'
shared.require 'v037r1.CPed'
shared.require 'CMatrix'
shared.require 'CVector'
shared.require 'v037r1.CLocalPlayer'
shared.require 'v037r1.CPlayerInfo'
shared.require 'v037r1.CRemotePlayer'
shared.require 'v037r1.SpecialAction'
shared.require 'v037r1.ControllerState'
shared.require 'v037r1.Animation'
shared.require 'v037r1.AimStuff'
shared.require 'v037r1.Synchronization'

shared.ffi.cdef[[
enum {
    MAX_PLAYERS = 1004,
};

#pragma pack(push, 1)
struct SC_6881 {
    ID m_nId;
    int __align;
    string m_szName;
    SCLocalPlayer* m_pObject;
    int m_nPing;
    int m_nScore;
};
typedef struct SC_6881 SC_6881;
#pragma pack(pop)

#pragma pack(push, 1)
struct SCPlayerPool {
    int m_nLargestId;
    SC_6881 m_localInfo;
    SCPlayerInfo* m_pObject[1004];
    BOOL m_bNotEmpty[1004];
    BOOL m_bPrevCollisionFlag[1004];
};
typedef struct SCPlayerPool SCPlayerPool;
#pragma pack(pop)

struct SAim {
    SCVector front;
    SCVector source;
    SCVector sourceBeforeLookBehind;
    SCVector up;
};
typedef struct SAim SAim;

#pragma pack(push, 1)
struct SOnfootData {
    SControllerState m_controllerState;
    SCVector m_position;
    float m_fQuaternion[4];
    unsigned char m_nHealth;
    unsigned char m_nArmor;
    unsigned char m_nCurrentWeapon;
    unsigned char m_nSpecialAction;
    SCVector m_speed;
    SCVector m_surfingOffset;
    ID m_nSurfingVehicleId;
    SAnimation m_animation;
};
typedef struct SOnfootData SOnfootData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SIncarData {
    ID m_nVehicle;
    SControllerState m_controllerState;
    float m_fQuaternion[4];
    SCVector m_position;
    SCVector m_speed;
    float m_fHealth;
    unsigned char m_nDriverHealth;
    unsigned char m_nDriverArmor;
    unsigned char m_nCurrentWeapon;
    bool m_bSirenEnabled;
    bool m_bLandingGear;
    ID m_nTrailerId;
    union {
        short unsigned int m_aHydraThrustAngle[2]; float m_fTrainSpeed;
    };
};
typedef struct SIncarData SIncarData;
#pragma pack(pop)

enum SWeaponState {
    WS_NO_BULLETS = 0,
    WS_LAST_BULLET = 1,
    WS_MORE_BULLETS = 2,
    WS_RELOADING = 3,
};
typedef enum SWeaponState SWeaponState;

#pragma pack(push, 1)
struct SAimData {
    unsigned char m_nCameraMode;
    SCVector m_aimf1;
    SCVector m_aimPos;
    float m_fAimZ;
    unsigned char m_nCameraExtZoom;
    unsigned char m_nWeaponState;
    char m_nAspectRatio;
};
typedef struct SAimData SAimData;
#pragma pack(pop)

#pragma pack(push, 1)
struct STrailerData {
    ID m_nId;
    SCVector m_position;
    float m_fQuaternion[4];
    SCVector m_speed;
    SCVector m_turnSpeed;
};
typedef struct STrailerData STrailerData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SPassengerData {
    ID m_nVehicleId;
    unsigned char m_nSeatId;
    unsigned char m_nCurrentWeapon;
    unsigned char m_nHealth;
    unsigned char m_nArmor;
    SControllerState m_controllerState;
    SCVector m_position;
};
typedef struct SPassengerData SPassengerData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SUnoccupiedData {
    ID m_nVehicleId;
    unsigned char m_nSeatId;
    SCVector m_roll;
    SCVector m_direction;
    SCVector m_position;
    SCVector m_speed;
    SCVector m_turnSpeed;
    float m_fHealth;
};
typedef struct SUnoccupiedData SUnoccupiedData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SBulletData {
    unsigned char m_nTargetType;
    ID m_nTargetId;
    SCVector m_origin;
    SCVector m_target;
    SCVector m_center;
    unsigned char m_nWeapon;
};
typedef struct SBulletData SBulletData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SSpectatorData {
    SControllerState m_controllerState;
    SCVector m_position;
};
typedef struct SSpectatorData SSpectatorData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SStatsData {
    int m_nMoney;
    int m_nDrunkLevel;
};
typedef struct SStatsData SStatsData;
#pragma pack(pop)
]]

shared.validate_size('struct SC_6881', 0x2a)
shared.validate_size('struct SCPlayerPool', 0x2f3e)
shared.validate_size('struct SAim', 0x30)
shared.validate_size('struct SOnfootData', 0x44)
shared.validate_size('struct SIncarData', 0x3f)
shared.validate_size('struct SAimData', 0x1f)
shared.validate_size('struct STrailerData', 0x36)
shared.validate_size('struct SPassengerData', 0x18)
shared.validate_size('struct SUnoccupiedData', 0x43)
shared.validate_size('struct SBulletData', 0x28)
shared.validate_size('struct SSpectatorData', 0x12)
shared.validate_size('struct SStatsData', 0x8)

local CPlayerPool_constructor = ffi.cast('void(__thiscall*)(SCPlayerPool*)', 0x10AD0)
local CPlayerPool_destructor = ffi.cast('void(__thiscall*)(SCPlayerPool*)', 0x10C20)
local function CPlayerPool_new(...)
    local obj = ffi.gc(ffi.new('struct SCPlayerPool[1]'), CPlayerPool_destructor)
    CPlayerPool_constructor(obj, ...)
    return obj
end

local SCPlayerPool_mt = {
    UpdateLargestId = ffi.cast('void(__thiscall*)(SCPlayerPool*)', shared.GetAddress(0x102B0)),
    Process = ffi.cast('void(__thiscall*)(SCPlayerPool*)', shared.GetAddress(0x10320)),
    Find = ffi.cast('ID(__thiscall*)(SCPlayerPool*, CPed*)', shared.GetAddress(0x10420)),
    Deactivate = ffi.cast('void(__thiscall*)(SCPlayerPool*)', shared.GetAddress(0x10650)),
    ForceCollision = ffi.cast('void(__thiscall*)(SCPlayerPool*)', shared.GetAddress(0x107B0)),
    RestoreCollision = ffi.cast('void(__thiscall*)(SCPlayerPool*)', shared.GetAddress(0x10820)),
    Delete = ffi.cast('int(__thiscall*)(SCPlayerPool*, ID, int)', shared.GetAddress(0x10B90)),
    Create = ffi.cast('BOOL(__thiscall*)(SCPlayerPool*, ID, const char*, BOOL)', shared.GetAddress(0x10D50)),
    GetPlayer = ffi.cast('SCRemotePlayer * (__thiscall*)(SCPlayerPool*, ID)', shared.GetAddress(0x10F0)),
    GetLocalPlayerName = ffi.cast('const char*(__thiscall*)(SCPlayerPool*)', shared.GetAddress(0x13CD0)),
    -- IsDisconnected = ...
    IsConnected = ffi.cast('BOOL(__thiscall*)(SCPlayerPool*, ID)', shared.GetAddress(0x10B0)),
    SetLocalPlayerName = ffi.cast('void(__thiscall*)(SCPlayerPool*, const char*)', shared.GetAddress(0xB3E0)),
    SetAt = ffi.cast('void(__thiscall*)(SCPlayerPool*, ID, SCPlayerInfo*)', shared.GetAddress(0x10290)),
    GetScore = ffi.cast('int(__thiscall*)(SCPlayerPool*, ID)', shared.GetAddress(0x6A190)),
    GetPing = ffi.cast('int(__thiscall*)(SCPlayerPool*, ID)', shared.GetAddress(0x6A1C0)),
    GetName = ffi.cast('const char*(__thiscall*)(SCPlayerPool*, ID)', shared.GetAddress(0x13CE0)),
    -- GetLocalPlayerPing = ...
    -- GetLocalPlayerScore = ...
    GetCount = ffi.cast('int(__thiscall*)(SCPlayerPool*, BOOL)', shared.GetAddress(0x10520)),
    GetLocalPlayer = ffi.cast('SCLocalPlayer * (__thiscall*)(SCPlayerPool*)', shared.GetAddress(0x1A30)),
    FindAccessory = ffi.cast('SCObject * (__thiscall*)(SCPlayerPool*, CObject*)', shared.GetAddress(0x106A0)),
    GetAt = ffi.cast('SCPlayerInfo * (__thiscall*)(SCPlayerPool*, ID)', shared.GetAddress(0x10D0)),
    IsNPC = ffi.cast('BOOL(__thiscall*)(SCPlayerPool*, ID)', shared.GetAddress(0xB680)),
    SetPing = ffi.cast('void(__thiscall*)(SCPlayerPool*, ID, int)', shared.GetAddress(0xB705)),
    SetScore = ffi.cast('void(__thiscall*)(SCPlayerPool*, ID, int)', shared.GetAddress(0xB6C0)),
}
SCPlayerPool_mt.__index = SCPlayerPool_mt
ffi.metatype('struct SCPlayerPool', SCPlayerPool_mt)

local AimStuff = {}

-- RefLocalPlayerCameraExtZoom = ...
-- RefLocalPlayerAspectRatio = ...
-- RefInternalCameraExtZoom = ...
-- RefInternalAspectRatio = ...
-- ArrayCameraExtZoom = ...
-- ArrayAspectRatio = ...
-- ArrayCameraMode = ...
-- RefInternalCameraMode = ...
-- RefLocalPlayerAim = ...
-- ArrayPlayerAim = ...
-- RefInternalAim = ...
-- UpdateCameraExtZoomAndAspectRatio = ...
-- ApplyCameraExtZoomAndAspectRatio = ...
-- SetCameraExtZoomAndAspectRatio = ...
-- GetAspectRatio = ...
-- GetCameraExtZoom = ...
-- ApplyCameraExtZoomAndAspectRatio = ...
-- SetCameraMode = ...
-- GetCameraMode = ...
-- GetCameraMode = ...
-- Initialize = ...
-- UpdateAim = ...
-- ApplyAim = ...
-- GetAim = ...
-- SetAim = ...
-- ApplyAim = ...
-- GetAim = ...
local Synchronization = {}

-- CompressAspectRatio = ...
-- DecompressAspectRatio = ...
-- CompressCameraExtZoom = ...
-- DecompressCameraExtZoom = ...

return {
    new = CPlayerPool_new,
    AimStuff = AimStuff,
    Synchronization = Synchronization,
}