local shared = require 'sampapi.shared'
local ffi = require 'ffi'

local function RefResourceMgr() return ffi.cast('CDXUTDialogResourceManager**', shared.GetAddress(0x21A180))[0] end
local function RefGameUi() return ffi.cast('CDXUTDialog**', shared.GetAddress(0x21A184))[0] end
local function RefScoreboard() return ffi.cast('CDXUTDialog**', shared.GetAddress(0x21A188))[0] end
local function RefDialog() return ffi.cast('CDXUTDialog**', shared.GetAddress(0x21A190))[0] end
local function RefClassSelection() return ffi.cast('CDXUTDialog**', shared.GetAddress(0x21A18C))[0] end
local function RefCursor() return ffi.cast('IDirect3DSurface9**', shared.GetAddress(0x21A198))[0] end
local function RefDevice() return ffi.cast('IDirect3DDevice9**', shared.GetAddress(0x21A0A8))[0] end
local Initialize = ffi.cast('void(__cdecl*)()', shared.GetAddress(0xB3FC0))
local OnLostDevice = ffi.cast('void(__cdecl*)()', shared.GetAddress(0xB2980))
local OnResetDevice = ffi.cast('void(__cdecl*)()', shared.GetAddress(0xB2BE0))
local GameUIEventHandler = ffi.cast('void(__stdcall*)(unsigned int, int, CDXUTControl*, void*)', shared.GetAddress(0xB3EE0))
local ScoreboardEventHandler = ffi.cast('void(__stdcall*)(unsigned int, int, CDXUTControl*, void*)', shared.GetAddress(0xB3F20))
local DialogEventHandler = ffi.cast('void(__stdcall*)(unsigned int, int, CDXUTControl*, void*)', shared.GetAddress(0xB3E50))
local ClassSelectorEventHandler = ffi.cast('void(__stdcall*)(unsigned int, int, CDXUTControl*, void*)', shared.GetAddress(0xB3F50))

return {
    RefResourceMgr = RefResourceMgr,
    RefGameUi = RefGameUi,
    RefScoreboard = RefScoreboard,
    RefDialog = RefDialog,
    RefClassSelection = RefClassSelection,
    RefCursor = RefCursor,
    RefDevice = RefDevice,
    Initialize = Initialize,
    OnLostDevice = OnLostDevice,
    OnResetDevice = OnResetDevice,
    GameUIEventHandler = GameUIEventHandler,
    ScoreboardEventHandler = ScoreboardEventHandler,
    DialogEventHandler = DialogEventHandler,
    ClassSelectorEventHandler = ClassSelectorEventHandler,
}